/*
 *------------------------------------------------------------------
 * googleanalytics.js
 *
 * Copyright (c) 2005-2008, 2010-2011 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */
var today = new Date();
var expiry = new Date(today.getTime() + 365 * 24 * 60 * 60 * 1000);
//var expiry = new Date();
function getCookieVal (offset) {
	var endstr = document.cookie.indexOf (";", offset);
	if (endstr == -1) { endstr = document.cookie.length; }
	return unescape(document.cookie.substring(offset, endstr));
}

function GetCookie (name) {
	var arg = name + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen) {
		var j = i + alen;
		if (document.cookie.substring(i, j) == arg) {
			return getCookieVal (j);
		}
		i = document.cookie.indexOf(" ", i) + 1;
		if (i == 0) break; 
	}
	return null;
}

function DeleteCookie (name,path,domain) {
	if (GetCookie(name)) {
		document.cookie = name + "=" +
		((path) ? "; path=" + path : "") +
		((domain) ? "; domain=" + domain : "") +
		"; expires=Thu, 01-Jan-70 00:00:01 GMT";
		}
}

function SetCookie (name,value,expires,path,domain,secure) {
	document.cookie = name + "=" + escape (value) +
		((expires) ? "; expires=" + expires.toGMTString() : "") +
		((path) ? "; path=" + path : "") +
		((domain) ? "; domain=" + domain : "") +
		((secure) ? "; secure" : "");
}
 
function getGATrackCode(){
	var _gaq = _gaq || [];
	_gaq.push(['_setAccount', 'UA-23096532-1']);
	_gaq.push(['_trackPageview']);
	
	(function() {
		var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
		ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
		var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();
}

var name = window.location.hostname+'ga';
function setUserAction(val){
   SetCookie(name,val, expiry);
   if(val==true)
      getGATrackCode();
	  
	  
}

var gaWindow=null;
function getGAAggrementStatus(){
	if (GetCookie(name) == null || GetCookie(name) == "undefined") {
		if(isCookiesEnabled()){
			var wt=650;
			var ht=300;
			var left = (screen.width/2)-(wt/2);
			var top = (screen.height/2)-(ht/2);
			gaWindow=window.open("gaaggrement.html","gaaggrement",'height='+ht+',width='+wt+',left='+left+',top='+top);
			gaWindow.focus();	
		}
		return 'false';
	}
	else {
		return GetCookie(name);  
	}
}
 
function disableGACapture(){
	var status = confirm("Do you want to disable Google Analytics Capture?");
	if(status)
		SetCookie(name,'false', expiry);
}
function enableGACapture(){
	var status = confirm("Do you want to enable Google Analytics Capture?");
	if(status)
		SetCookie(name,'true', expiry);
}
function isCookiesEnabled(){
	var varCook='varCook';
	SetCookie(varCook,varCook,expiry);
	if (GetCookie(varCook) != varCook)
		return false
	else
		return true;
} 

 
 